﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_DecreaseQuotaForNewUsedCases]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[sp_DecreaseQuotaForNewUsedCases]
GO

CREATE PROCEDURE [dbo].[sp_DecreaseQuotaForNewUsedCases] 
	@newUsedCases AS [dbo].[RespondentsIdList] READONLY
AS
BEGIN
	UPDATE Quota 
	SET QtUnused = QtUnused - StrUnused
	FROM Quota 
	INNER JOIN (
		SELECT StrQuotaID, SUM(IncrementValue) AS StrUnused 
		FROM Stratum
		INNER JOIN @newUsedCases ON Id = StrRespondent
		GROUP BY StrQuotaID
	) AS s
	ON QtQuotaID = StrQuotaID
END
